/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain.caves;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;
import org.betterx.betterend.world.features.terrain.caves.CaveChunkPopulatorFeatureConfig;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class CaveChunkPopulatorFeature
extends Feature<CaveChunkPopulatorFeatureConfig> {
    public CaveChunkPopulatorFeature() {
        super(CaveChunkPopulatorFeatureConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<CaveChunkPopulatorFeatureConfig> featureConfig) {
        CaveChunkPopulatorFeatureConfig cfg = (CaveChunkPopulatorFeatureConfig)featureConfig.m_159778_();
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        ChunkGenerator chunkGenerator = featureConfig.m_159775_();
        HashSet floorPositions = Sets.newHashSet();
        HashSet ceilPositions = Sets.newHashSet();
        int sx = pos.m_123341_() >> 4 << 4;
        int sz = pos.m_123343_() >> 4 << 4;
        BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        this.fillSets(sx, sz, world.m_46865_(pos), floorPositions, ceilPositions, min, max);
        EndCaveBiome biome = cfg.getCaveBiome();
        if (BCLBiomeRegistry.isEmptyBiome((BCLBiome)biome)) {
            return false;
        }
        BlockState surfaceBlock = Blocks.f_50259_.m_49966_();
        this.placeFloor(world, chunkGenerator, biome, floorPositions, random, surfaceBlock);
        this.placeCeil(world, chunkGenerator, biome, ceilPositions, random);
        BlockFixer.fixBlocks((LevelAccessor)world, (BlockPos)min, (BlockPos)max);
        return true;
    }

    protected void fillSets(int sx, int sz, ChunkAccess chunk, Set<BlockPos> floorPositions, Set<BlockPos> ceilPositions, BlockPos.MutableBlockPos min, BlockPos.MutableBlockPos max) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mut2 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mut3 = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            mut.m_142451_(x);
            mut2.m_142451_(x);
            for (int z = 0; z < 16; ++z) {
                mut.m_142443_(z);
                mut2.m_142443_(z);
                mut2.m_142448_(0);
                for (int y = 1; y < chunk.m_151558_(); ++y) {
                    mut.m_142448_(y);
                    BlockState top = chunk.m_8055_((BlockPos)mut);
                    BlockState bottom = chunk.m_8055_((BlockPos)mut2);
                    if (top.m_60795_() && (bottom.m_204336_(CommonBlockTags.GEN_END_STONES) || bottom.m_60713_(Blocks.f_50069_))) {
                        mut3.m_122190_((Vec3i)mut2).m_122184_(sx, 0, sz);
                        floorPositions.add(mut3.m_7949_());
                        this.updateMin((BlockPos)mut3, min);
                        this.updateMax((BlockPos)mut3, max);
                    } else if (bottom.m_60795_() && (top.m_204336_(CommonBlockTags.GEN_END_STONES) || top.m_60713_(Blocks.f_50069_))) {
                        mut3.m_122190_((Vec3i)mut).m_122184_(sx, 0, sz);
                        ceilPositions.add(mut3.m_7949_());
                        this.updateMin((BlockPos)mut3, min);
                        this.updateMax((BlockPos)mut3, max);
                    }
                    mut2.m_142448_(y);
                }
            }
        }
    }

    private void updateMin(BlockPos pos, BlockPos.MutableBlockPos min) {
        if (pos.m_123341_() < min.m_123341_()) {
            min.m_142451_(pos.m_123341_());
        }
        if (pos.m_123342_() < min.m_123342_()) {
            min.m_142448_(pos.m_123342_());
        }
        if (pos.m_123343_() < min.m_123343_()) {
            min.m_142443_(pos.m_123343_());
        }
    }

    private void updateMax(BlockPos pos, BlockPos.MutableBlockPos max) {
        if (pos.m_123341_() > max.m_123341_()) {
            max.m_142451_(pos.m_123341_());
        }
        if (pos.m_123342_() > max.m_123342_()) {
            max.m_142448_(pos.m_123342_());
        }
        if (pos.m_123343_() > max.m_123343_()) {
            max.m_142443_(pos.m_123343_());
        }
    }

    protected void placeFloor(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> floorPositions, RandomSource random, BlockState surfaceBlock) {
        float density = biome.getFloorDensity();
        floorPositions.forEach(pos -> {
            ConfiguredFeature feature;
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)surfaceBlock);
            if (density > 0.0f && random.m_188501_() <= density && (feature = (ConfiguredFeature)biome.getFloorFeature(random).m_203334_()) != null) {
                feature.m_224953_(world, generator, random, pos.m_7494_());
            }
        });
    }

    protected void placeCeil(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> ceilPositions, RandomSource random) {
        float density = biome.getCeilDensity();
        ceilPositions.forEach(pos -> {
            ConfiguredFeature feature;
            BlockState ceilBlock = biome.getCeil((BlockPos)pos);
            if (ceilBlock != null) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)ceilBlock);
            }
            if (density > 0.0f && random.m_188501_() <= density && (feature = (ConfiguredFeature)biome.getCeilFeature(random).m_203334_()) != null) {
                feature.m_224953_(world, generator, random, pos.m_7495_());
            }
        });
    }
}

